clear all
set type double
set more off

*** create rt vintages
tempfile U
insheet using UNEMPLOY_4.txt, clear
gen int mdate = mofd(date(observation_date,"YMD"))
tsset mdate, m
drop observation_date realtime_start_date
rename unemploy U
save `U'

insheet using CE16OV_4.txt, clear
gen int mdate = mofd(date(observation_date,"YMD"))
tsset mdate, m
drop observation_date realtime_start_date
rename ce16ov E

merge 1:1 mdate using `U', nogen
gen v1ur = 100*U/(U+E)

keep if mdate>=tm(1948m1)

tsset mdate, m
order mdate
compress
keep mdate v1ur
save v1ur.dta, replace
